#include "resources.h"
#include "cpp-utils.h"

std::string global_resource_root;

std::vector<std::shared_ptr<QImage>> topdown_backgrounds;
std::vector<std::shared_ptr<QImage>> topdown_simple_backgrounds;
std::vector<std::shared_ptr<QImage>> platform_backgrounds;
std::vector<std::shared_ptr<QImage>> space_backgrounds;
std::vector<std::shared_ptr<QImage>> water_backgrounds;
std::vector<std::shared_ptr<QImage>> water_surface_backgrounds;

std::map<std::string, std::shared_ptr<QImage>> sprites;

std::shared_ptr<QImage> get_asset_ptr(std::string relpath) {
    return sprites.at(relpath);
}

std::shared_ptr<QImage> load_resource_ptr(std::string relpath, QImage::Format format) {
    auto path = global_resource_root + relpath;
    auto asset = QImage(QString(path.c_str())).convertToFormat(format);
    auto asset_ptr = std::make_shared<QImage>(asset);

    if (asset_ptr->width() == 0) {
        fatal("failed to load image %s\n", path.c_str());
    }
    return asset_ptr;
}

void images_load() {
    auto sprite_paths = std::vector<std::string>{
        "kenney/Ground/Planet/planetCorner_left.png",
        "kenney/Ground/Planet/planetHill_left.png",
        "kenney/Ground/Planet/planetHalf_right.png",
        "kenney/Ground/Planet/planet.png",
        "kenney/Ground/Planet/planetHalf_mid.png",
        "kenney/Ground/Planet/planetHalf_left.png",
        "kenney/Ground/Planet/planetCorner_right.png",
        "kenney/Ground/Planet/planetRight.png",
        "kenney/Ground/Planet/planetCliff_right.png",
        "kenney/Ground/Planet/planetCenter_rounded.png",
        "kenney/Ground/Planet/planetCenter.png",
        "kenney/Ground/Planet/planetHalf.png",
        "kenney/Ground/Planet/planetCliffAlt_left.png",
        "kenney/Ground/Planet/planetLeft.png",
        "kenney/Ground/Planet/planetMid.png",
        "kenney/Ground/Planet/planetCliffAlt_right.png",
        "kenney/Ground/Planet/planetCliff_left.png",
        "kenney/Ground/Planet/planetHill_right.png",
        "kenney/Ground/Grass/grassHill_left.png",
        "kenney/Ground/Grass/grassHill_right.png",
        "kenney/Ground/Grass/grassCliffAlt_right.png",
        "kenney/Ground/Grass/grassCliff_left.png",
        "kenney/Ground/Grass/grassHalf_left.png",
        "kenney/Ground/Grass/grassCliff_right.png",
        "kenney/Ground/Grass/grassCorner_right.png",
        "kenney/Ground/Grass/grassHalf_mid.png",
        "kenney/Ground/Grass/grassRight.png",
        "kenney/Ground/Grass/grassCenter_round.png",
        "kenney/Ground/Grass/grass.png",
        "kenney/Ground/Grass/grassHalf.png",
        "kenney/Ground/Grass/grassCenter.png",
        "kenney/Ground/Grass/grassLeft.png",
        "kenney/Ground/Grass/grassHalf_right.png",
        "kenney/Ground/Grass/grassCorner_left.png",
        "kenney/Ground/Grass/grassCliffAlt_left.png",
        "kenney/Ground/Grass/grassMid.png",
        "kenney/Ground/Stone/stoneCliffAlt_left.png",
        "kenney/Ground/Stone/stoneCliffAlt_right.png",
        "kenney/Ground/Stone/stoneMid.png",
        "kenney/Ground/Stone/stoneCorner_left.png",
        "kenney/Ground/Stone/stoneHalf_left.png",
        "kenney/Ground/Stone/stoneHalf_right.png",
        "kenney/Ground/Stone/stoneHill_left.png",
        "kenney/Ground/Stone/stoneCenter_rounded.png",
        "kenney/Ground/Stone/stoneHalf_mid.png",
        "kenney/Ground/Stone/stoneCorner_right.png",
        "kenney/Ground/Stone/stone.png",
        "kenney/Ground/Stone/stoneHalf.png",
        "kenney/Ground/Stone/stoneCliff_left.png",
        "kenney/Ground/Stone/stoneLeft.png",
        "kenney/Ground/Stone/stoneHill_right.png",
        "kenney/Ground/Stone/stoneCenter.png",
        "kenney/Ground/Stone/stoneCliff_right.png",
        "kenney/Ground/Stone/stoneRight.png",
        "kenney/Ground/Snow/snowCliff_left.png",
        "kenney/Ground/Snow/snowRight.png",
        "kenney/Ground/Snow/snowHill_right.png",
        "kenney/Ground/Snow/snowCliff_right.png",
        "kenney/Ground/Snow/snow.png",
        "kenney/Ground/Snow/snowCenter.png",
        "kenney/Ground/Snow/snowMid.png",
        "kenney/Ground/Snow/snowCliffAlt_left.png",
        "kenney/Ground/Snow/snowCorner_right.png",
        "kenney/Ground/Snow/snowCenter_rounded.png",
        "kenney/Ground/Snow/snowCorner_left.png",
        "kenney/Ground/Snow/snowLeft.png",
        "kenney/Ground/Snow/snowHalf_left.png",
        "kenney/Ground/Snow/snowHalf.png",
        "kenney/Ground/Snow/snowHill_left.png",
        "kenney/Ground/Snow/snowHalf_mid.png",
        "kenney/Ground/Snow/snowCliffAlt_right.png",
        "kenney/Ground/Snow/snowHalf_right.png",
        "kenney/Ground/Dirt/dirtCliff_left.png",
        "kenney/Ground/Dirt/dirt.png",
        "kenney/Ground/Dirt/dirtHill_right.png",
        "kenney/Ground/Dirt/dirtCliff_right.png",
        "kenney/Ground/Dirt/dirtHill_left.png",
        "kenney/Ground/Dirt/dirtHalf_left.png",
        "kenney/Ground/Dirt/dirtCenter_rounded.png",
        "kenney/Ground/Dirt/dirtCorner_left.png",
        "kenney/Ground/Dirt/dirtCliffAlt_left.png",
        "kenney/Ground/Dirt/dirtRight.png",
        "kenney/Ground/Dirt/dirtCorner_right.png",
        "kenney/Ground/Dirt/dirtCenter.png",
        "kenney/Ground/Dirt/dirtHalf.png",
        "kenney/Ground/Dirt/dirtHalf_right.png",
        "kenney/Ground/Dirt/dirtCliffAlt_right.png",
        "kenney/Ground/Dirt/dirtMid.png",
        "kenney/Ground/Dirt/dirtLeft.png",
        "kenney/Ground/Dirt/dirtHalf_mid.png",
        "kenney/Ground/Sand/sandHalf_right.png",
        "kenney/Ground/Sand/sandCorner_right.png",
        "kenney/Ground/Sand/sandHill_left.png",
        "kenney/Ground/Sand/sandCenter.png",
        "kenney/Ground/Sand/sandHalf_mid.png",
        "kenney/Ground/Sand/sandHalf_left.png",
        "kenney/Ground/Sand/sandRight.png",
        "kenney/Ground/Sand/sandCorner_leftg.png",
        "kenney/Ground/Sand/sandMid.png",
        "kenney/Ground/Sand/sandCliffAlt_right.png",
        "kenney/Ground/Sand/sandCliffAlt_left.png",
        "kenney/Ground/Sand/sandHill_right.png",
        "kenney/Ground/Sand/sandHalf.png",
        "kenney/Ground/Sand/sand.png",
        "kenney/Ground/Sand/sandCliff_right.png",
        "kenney/Ground/Sand/sandCenter_rounded.png",
        "kenney/Ground/Sand/sandCliff_left.png",
        "kenney/Ground/Sand/sandLeft.png",
        "kenney/Players/Variable sizes/Green/alienGreen_climb1.png",
        "kenney/Players/Variable sizes/Green/alienGreen_stand.png",
        "kenney/Players/Variable sizes/Green/alienGreen_climb2.png",
        "kenney/Players/Variable sizes/Green/alienGreen_duck.png",
        "kenney/Players/Variable sizes/Green/alienGreen_jump.png",
        "kenney/Players/Variable sizes/Green/alienGreen_hit.png",
        "kenney/Players/Variable sizes/Green/alienGreen_walk1.png",
        "kenney/Players/Variable sizes/Green/alienGreen_walk2.png",
        "kenney/Players/Variable sizes/Green/alienGreen_swim1.png",
        "kenney/Players/Variable sizes/Green/alienGreen_swim2.png",
        "kenney/Players/Variable sizes/Green/alienGreen_front.png",
        "kenney/Players/Variable sizes/Blue/alienBlue_stand.png",
        "kenney/Players/Variable sizes/Blue/alienBlue_climb2.png",
        "kenney/Players/Variable sizes/Blue/alienBlue_walk2.png",
        "kenney/Players/Variable sizes/Blue/alienBlue_climb1.png",
        "kenney/Players/Variable sizes/Blue/alienBlue_hit.png",
        "kenney/Players/Variable sizes/Blue/alienBlue_walk1.png",
        "kenney/Players/Variable sizes/Blue/alienBlue_swim2.png",
        "kenney/Players/Variable sizes/Blue/alienBlue_front.png",
        "kenney/Players/Variable sizes/Blue/alienBlue_swim1.png",
        "kenney/Players/Variable sizes/Blue/alienBlue_jump.png",
        "kenney/Players/Variable sizes/Blue/alienBlue_duck.png",
        "kenney/Players/Variable sizes/Pink/alienPink_swim1.png",
        "kenney/Players/Variable sizes/Pink/alienPink_front.png",
        "kenney/Players/Variable sizes/Pink/alienPink_swim2.png",
        "kenney/Players/Variable sizes/Pink/alienPink_hit.png",
        "kenney/Players/Variable sizes/Pink/alienPink_duck.png",
        "kenney/Players/Variable sizes/Pink/alienPink_jump.png",
        "kenney/Players/Variable sizes/Pink/alienPink_stand.png",
        "kenney/Players/Variable sizes/Pink/alienPink_walk1.png",
        "kenney/Players/Variable sizes/Pink/alienPink_climb1.png",
        "kenney/Players/Variable sizes/Pink/alienPink_walk2.png",
        "kenney/Players/Variable sizes/Pink/alienPink_climb2.png",
        "kenney/Players/Variable sizes/Beige/alienBiege_walk1.png",
        "kenney/Players/Variable sizes/Beige/alienBiege_climb1.png",
        "kenney/Players/Variable sizes/Beige/alienBiege_walk2.png",
        "kenney/Players/Variable sizes/Beige/alienBiege_climb2.png",
        "kenney/Players/Variable sizes/Beige/alienBiege_stand.png",
        "kenney/Players/Variable sizes/Beige/alienBiege_hit.png",
        "kenney/Players/Variable sizes/Beige/alienBiege_jump.png",
        "kenney/Players/Variable sizes/Beige/alienBiege_swim1.png",
        "kenney/Players/Variable sizes/Beige/alienBiege_front.png",
        "kenney/Players/Variable sizes/Beige/alienBiege_swim2.png",
        "kenney/Players/Variable sizes/Beige/alienBiege_duck.png",
        "kenney/Players/Variable sizes/Yellow/alienYellow_jump.png",
        "kenney/Players/Variable sizes/Yellow/alienYellow_hit.png",
        "kenney/Players/Variable sizes/Yellow/alienYellow_duck.png",
        "kenney/Players/Variable sizes/Yellow/alienYellow_climb1.png",
        "kenney/Players/Variable sizes/Yellow/alienYellow_swim1.png",
        "kenney/Players/Variable sizes/Yellow/alienYellow_front.png",
        "kenney/Players/Variable sizes/Yellow/alienYellow_climb2.png",
        "kenney/Players/Variable sizes/Yellow/alienYellow_swim2.png",
        "kenney/Players/Variable sizes/Yellow/alienYellow_walk1.png",
        "kenney/Players/Variable sizes/Yellow/alienYellow_walk2.png",
        "kenney/Players/Variable sizes/Yellow/alienYellow_stand.png",
        "kenney/Players/128x256/Green/alienGreen_climb1.png",
        "kenney/Players/128x256/Green/alienGreen_stand.png",
        "kenney/Players/128x256/Green/alienGreen_climb2.png",
        "kenney/Players/128x256/Green/alienGreen_duck.png",
        "kenney/Players/128x256/Green/alienGreen_jump.png",
        "kenney/Players/128x256/Green/alienGreen_hit.png",
        "kenney/Players/128x256/Green/alienGreen_walk1.png",
        "kenney/Players/128x256/Green/alienGreen_walk2.png",
        "kenney/Players/128x256/Green/alienGreen_swim1.png",
        "kenney/Players/128x256/Green/alienGreen_swim2.png",
        "kenney/Players/128x256/Green/alienGreen_front.png",
        "kenney/Players/128x256/Blue/alienBlue_stand.png",
        "kenney/Players/128x256/Blue/alienBlue_climb2.png",
        "kenney/Players/128x256/Blue/alienBlue_walk2.png",
        "kenney/Players/128x256/Blue/alienBlue_climb1.png",
        "kenney/Players/128x256/Blue/alienBlue_hit.png",
        "kenney/Players/128x256/Blue/alienBlue_walk1.png",
        "kenney/Players/128x256/Blue/alienBlue_swim2.png",
        "kenney/Players/128x256/Blue/alienBlue_front.png",
        "kenney/Players/128x256/Blue/alienBlue_swim1.png",
        "kenney/Players/128x256/Blue/alienBlue_jump.png",
        "kenney/Players/128x256/Blue/alienBlue_duck.png",
        "kenney/Players/128x256/Pink/alienPink_swim1.png",
        "kenney/Players/128x256/Pink/alienPink_front.png",
        "kenney/Players/128x256/Pink/alienPink_swim2.png",
        "kenney/Players/128x256/Pink/alienPink_hit.png",
        "kenney/Players/128x256/Pink/alienPink_duck.png",
        "kenney/Players/128x256/Pink/alienPink_jump.png",
        "kenney/Players/128x256/Pink/alienPink_stand.png",
        "kenney/Players/128x256/Pink/alienPink_walk1.png",
        "kenney/Players/128x256/Pink/alienPink_climb1.png",
        "kenney/Players/128x256/Pink/alienPink_walk2.png",
        "kenney/Players/128x256/Pink/alienPink_climb2.png",
        "kenney/Players/128x256/Beige/alienBeige_stand.png",
        "kenney/Players/128x256/Beige/alienBeige_duck.png",
        "kenney/Players/128x256/Beige/alienBeige_jump.png",
        "kenney/Players/128x256/Beige/alienBeige_walk2.png",
        "kenney/Players/128x256/Beige/alienBeige_hit.png",
        "kenney/Players/128x256/Beige/alienBeige_walk1.png",
        "kenney/Players/128x256/Beige/alienBeige_front.png",
        "kenney/Players/128x256/Beige/alienBeige_swim2.png",
        "kenney/Players/128x256/Beige/alienBeige_swim1.png",
        "kenney/Players/128x256/Beige/alienBeige_climb2.png",
        "kenney/Players/128x256/Beige/alienBeige_climb1.png",
        "kenney/Players/128x256/Yellow/alienYellow_jump.png",
        "kenney/Players/128x256/Yellow/alienYellow_hit.png",
        "kenney/Players/128x256/Yellow/alienYellow_duck.png",
        "kenney/Players/128x256/Yellow/alienYellow_climb1.png",
        "kenney/Players/128x256/Yellow/alienYellow_swim1.png",
        "kenney/Players/128x256/Yellow/alienYellow_front.png",
        "kenney/Players/128x256/Yellow/alienYellow_climb2.png",
        "kenney/Players/128x256/Yellow/alienYellow_swim2.png",
        "kenney/Players/128x256/Yellow/alienYellow_walk1.png",
        "kenney/Players/128x256/Yellow/alienYellow_walk2.png",
        "kenney/Players/128x256/Yellow/alienYellow_stand.png",
        "kenney/Particles/brickBrown.png",
        "kenney/Particles/brickGrey.png",
        "kenney/Particles/fireball.png",
        "kenney/Tiles/lava.png",
        "kenney/Tiles/boxExplosive_used.png",
        "kenney/Tiles/ladderMid.png",
        "kenney/Tiles/fence.png",
        "kenney/Tiles/sprung.png",
        "kenney/Tiles/bomb.png",
        "kenney/Tiles/bridgeA.png",
        "kenney/Tiles/brickBrown.png",
        "kenney/Tiles/boxExplosive_disabled.png",
        "kenney/Tiles/bridgeB.png",
        "kenney/Tiles/waterTop_low.png",
        "kenney/Tiles/lavaTop_high.png",
        "kenney/Tiles/boxCoin_boxed.png",
        "kenney/Tiles/lockGreen.png",
        "kenney/Tiles/chain.png",
        "kenney/Tiles/boxCrate_double.png",
        "kenney/Tiles/boxCrate_warning.png",
        "kenney/Tiles/lockRed.png",
        "kenney/Tiles/boxCrate.png",
        "kenney/Tiles/ladderTop.png",
        "kenney/Tiles/cactus.png",
        "kenney/Tiles/brickGrey.png",
        "kenney/Tiles/rock.png",
        "kenney/Tiles/snow.png",
        "kenney/Tiles/switchGreen_pressed.png",
        "kenney/Tiles/switchRed_pressed.png",
        "kenney/Tiles/sign.png",
        "kenney/Tiles/switchRed.png",
        "kenney/Tiles/spring.png",
        "kenney/Tiles/weight.png",
        "kenney/Tiles/mushroomRed.png",
        "kenney/Tiles/plantPurple.png",
        "kenney/Tiles/boxCoin_disabled_boxed.png",
        "kenney/Tiles/waterTop_high.png",
        "kenney/Tiles/grass.png",
        "kenney/Tiles/boxCoin.png",
        "kenney/Tiles/weightAttached.png",
        "kenney/Tiles/lockBlue.png",
        "kenney/Tiles/boxItem_disabled.png",
        "kenney/Tiles/switchGreen.png",
        "kenney/Tiles/switchYellow.png",
        "kenney/Tiles/window.png",
        "kenney/Tiles/doorOpen_top.png",
        "kenney/Tiles/doorClosed_top.png",
        "kenney/Tiles/switchYellow_pressed.png",
        "kenney/Tiles/water.png",
        "kenney/Tiles/spikes.png",
        "kenney/Tiles/fenceBroken.png",
        "kenney/Tiles/boxItem_boxed.png",
        "kenney/Tiles/boxCrate_single.png",
        "kenney/Tiles/doorOpen_mid.png",
        "kenney/Tiles/leverRight.png",
        "kenney/Tiles/lockYellow.png",
        "kenney/Tiles/torch2.png",
        "kenney/Tiles/torchOff.png",
        "kenney/Tiles/leverLeft.png",
        "kenney/Tiles/boxItem_disabled_boxed.png",
        "kenney/Tiles/leverMid.png",
        "kenney/Tiles/lavaTop_low.png",
        "kenney/Tiles/boxItem.png",
        "kenney/Tiles/bombWhite.png",
        "kenney/Tiles/mushroomBrown.png",
        "kenney/Tiles/torch1.png",
        "kenney/Tiles/signExit.png",
        "kenney/Tiles/boxExplosive.png",
        "kenney/Tiles/signLeft.png",
        "kenney/Tiles/switchBlue_pressed.png",
        "kenney/Tiles/bush.png",
        "kenney/Tiles/switchBlue.png",
        "kenney/Tiles/boxCoin_disabled.png",
        "kenney/Tiles/signRight.png",
        "kenney/Tiles/doorClosed_mid.png",
        "kenney/Backgrounds/colored_shroom.png",
        "kenney/Backgrounds/colored_grass.png",
        "kenney/Backgrounds/colored_land.png",
        "kenney/Backgrounds/colored_desert.png",
        "kenney/Backgrounds/blue_desert.png",
        "kenney/Backgrounds/blue_grass.png",
        "kenney/Backgrounds/blue_shroom.png",
        "kenney/Backgrounds/blue_land.png",
        "kenney/Items/flagRed2.png",
        "kenney/Items/coinSilver.png",
        "kenney/Items/flagBlue_down.png",
        "kenney/Items/flagRed1.png",
        "kenney/Items/keyGreen.png",
        "kenney/Items/gemYellow.png",
        "kenney/Items/flagGreen_down.png",
        "kenney/Items/flagYellow_down.png",
        "kenney/Items/flagYellow2.png",
        "kenney/Items/flagYellow1.png",
        "kenney/Items/keyYellow.png",
        "kenney/Items/coinGold.png",
        "kenney/Items/keyRed.png",
        "kenney/Items/gemGreen.png",
        "kenney/Items/flagBlue1.png",
        "kenney/Items/flagBlue2.png",
        "kenney/Items/keyBlue.png",
        "kenney/Items/star.png",
        "kenney/Items/coinBronze.png",
        "kenney/Items/gemBlue.png",
        "kenney/Items/flagGreen2.png",
        "kenney/Items/flagRed_down.png",
        "kenney/Items/flagGreen1.png",
        "kenney/Items/gemRed.png",
        "kenney/Enemies/snail_shell.png",
        "kenney/Enemies/fly_move.png",
        "kenney/Enemies/ladybug_fly.png",
        "kenney/Enemies/slimePurple_dead.png",
        "kenney/Enemies/mouse_dead.png",
        "kenney/Enemies/slimeBlue_hit.png",
        "kenney/Enemies/saw.png",
        "kenney/Enemies/sawHalf.png",
        "kenney/Enemies/saw_move.png",
        "kenney/Enemies/slimeGreen_move.png",
        "kenney/Enemies/slimeGreen_hit.png",
        "kenney/Enemies/barnacle_dead.png",
        "kenney/Enemies/slimeBlue_dead.png",
        "kenney/Enemies/slimeBlue.png",
        "kenney/Enemies/frog_move.png",
        "kenney/Enemies/fly.png",
        "kenney/Enemies/slimePurple_hit.png",
        "kenney/Enemies/slimeBlock_dead.png",
        "kenney/Enemies/wormPink_dead.png",
        "kenney/Enemies/snail_move.png",
        "kenney/Enemies/fishBlue_dead.png",
        "kenney/Enemies/ladybug_move.png",
        "kenney/Enemies/bee_dead.png",
        "kenney/Enemies/slimePurple.png",
        "kenney/Enemies/fishGreen_dead.png",
        "kenney/Enemies/fishPink_move.png",
        "kenney/Enemies/slimeGreen.png",
        "kenney/Enemies/wormGreen.png",
        "kenney/Enemies/ladybug.png",
        "kenney/Enemies/wormGreen_move.png",
        "kenney/Enemies/sawHalf_dead.png",
        "kenney/Enemies/bee.png",
        "kenney/Enemies/slimeBlock.png",
        "kenney/Enemies/fishBlue.png",
        "kenney/Enemies/fishPink.png",
        "kenney/Enemies/fishGreen_move.png",
        "kenney/Enemies/mouse.png",
        "kenney/Enemies/fishPink_dead.png",
        "kenney/Enemies/wormGreen_dead.png",
        "kenney/Enemies/sawHalf_move.png",
        "kenney/Enemies/frog.png",
        "kenney/Enemies/bee_move.png",
        "kenney/Enemies/barnacle.png",
        "kenney/Enemies/frog_dead.png",
        "kenney/Enemies/slimeBlue_move.png",
        "kenney/Enemies/fishBlue_fall.png",
        "kenney/Enemies/wormPink_move.png",
        "kenney/Enemies/fishGreen.png",
        "kenney/Enemies/slimeBlock_move.png",
        "kenney/Enemies/slimePurple_move.png",
        "kenney/Enemies/fly_dead.png",
        "kenney/Enemies/mouse_move.png",
        "kenney/Enemies/barnacle_attack.png",
        "kenney/Enemies/saw_dead.png",
        "kenney/Enemies/slimeGreen_dead.png",
        "kenney/Enemies/snail.png",
        "kenney/Enemies/wormPink.png",
        "kenney/HUD/hudHeart_half.png",
        "kenney/HUD/hudJewel_red_empty.png",
        "kenney/HUD/hudJewel_yellow_empty.png",
        "kenney/HUD/hudCoin.png",
        "kenney/HUD/hudHeart_empty.png",
        "kenney/HUD/hudPlayer_beige.png",
        "kenney/HUD/hudKey_green_empty.png",
        "kenney/HUD/hudKey_blue.png",
        "kenney/HUD/hudHeart_full.png",
        "kenney/HUD/hudX.png",
        "kenney/HUD/hud9.png",
        "kenney/HUD/hud8.png",
        "kenney/HUD/hudKey_red.png",
        "kenney/HUD/hud3.png",
        "kenney/HUD/hud2.png",
        "kenney/HUD/hudKey_green.png",
        "kenney/HUD/hud0.png",
        "kenney/HUD/hud1.png",
        "kenney/HUD/hudPlayer_green.png",
        "kenney/HUD/hudPlayer_yellow.png",
        "kenney/HUD/hud5.png",
        "kenney/HUD/hud4.png",
        "kenney/HUD/hudJewel_green.png",
        "kenney/HUD/hudKey_blue_empty.png",
        "kenney/HUD/hud6.png",
        "kenney/HUD/hudJewel_yellow.png",
        "kenney/HUD/hud7.png",
        "kenney/HUD/hudJewel_green_empty.png",
        "kenney/HUD/hudKey_red_empty.png",
        "kenney/HUD/hudKey_yellow_empty.png",
        "kenney/HUD/hudPlayer_blue.png",
        "kenney/HUD/hudPlayer_pink.png",
        "kenney/HUD/hudJewel_blue.png",
        "kenney/HUD/hudJewel_blue_empty.png",
        "kenney/HUD/hudJewel_red.png",
        "kenney/HUD/hudKey_yellow.png",
        "misc_assets/car_green_2.png",
        "misc_assets/enemyShipBlack4.png",
        "misc_assets/tank_sand.png",
        "misc_assets/towerDefense_tile297.png",
        "misc_assets/fire_5.png",
        "misc_assets/car_black_4.png",
        "misc_assets/spaceRockets_001.png",
        "misc_assets/enemyFlying_2.png",
        "misc_assets/fruit3.png",
        "misc_assets/tank_green.png",
        "misc_assets/spaceAstronauts_008.png",
        "misc_assets/fruit2.png",
        "misc_assets/enemyFlying_3.png",
        "misc_assets/car_black_5.png",
        "misc_assets/fire_4.png",
        "misc_assets/towerDefense_tile296.png",
        "misc_assets/ufoRed2.png",
        "misc_assets/saw.png",
        "misc_assets/blockGreen.png",
        "misc_assets/enemyShipBlack5.png",
        "misc_assets/car_green_3.png",
        "misc_assets/bomb.png",
        "misc_assets/car_green_1.png",
        "misc_assets/robot_3Dblue.png",
        "misc_assets/fire_6.png",
        "misc_assets/spaceRockets_002.png",
        "misc_assets/enemyFlying_1.png",
        "misc_assets/keyGreen.png",
        "misc_assets/enemyShipRed4.png",
        "misc_assets/enemyShipRed5.png",
        "misc_assets/playerShip2_orange.png",
        "misc_assets/tank_bigRed.png",
        "misc_assets/fruit1.png",
        "misc_assets/spaceRockets_003.png",
        "misc_assets/towerDefense_tile295.png",
        "misc_assets/gemYellow.png",
        "misc_assets/enemyShipBlack2.png",
        "misc_assets/car_green_4.png",
        "misc_assets/car_black_2.png",
        "misc_assets/fire_3.png",
        "misc_assets/enemyFlying_4.png",
        "misc_assets/groundC.png",
        "misc_assets/fruit5.png",
        "misc_assets/enemyShipRed1.png",
        "misc_assets/spikeMan_stand.png",
        "misc_assets/fruit4.png",
        "misc_assets/ladder_small.png",
        "misc_assets/groundB.png",
        "misc_assets/fire_2.png",
        "misc_assets/car_black_3.png",
        "misc_assets/playerShip1_green.png",
        "misc_assets/car_green_5.png",
        "misc_assets/enemyShipBlack3.png",
        "misc_assets/dirt.png",
        "misc_assets/enemyShipBlack1.png",
        "misc_assets/spaceStation_019.png",
        "misc_assets/car_black_1.png",
        "misc_assets/fire1.png",
        "misc_assets/spaceRockets_004.png",
        "misc_assets/fruit6.png",
        "misc_assets/laserBlue02.png",
        "misc_assets/tile_318.png",
        "misc_assets/enemyShipRed2.png",
        "misc_assets/enemyShipRed3.png",
        "misc_assets/yellowCrystal.png",
        "misc_assets/cannonBall.png",
        "misc_assets/groundA.png",
        "misc_assets/fire_1.png",
        "misc_assets/spaceStation_018.png",
        "misc_assets/enemyWalking_4.png",
        "misc_assets/enemySpikey_3.png",
        "misc_assets/frog5.png",
        "misc_assets/character10.png",
        "misc_assets/character5.png",
        "misc_assets/ball_soccer2.png",
        "misc_assets/spaceEffect8.png",
        "misc_assets/enemyShipGreen5.png",
        "misc_assets/spaceMeteors_003.png",
        "misc_assets/dirt_2.png",
        "misc_assets/enemyWalking_1b.png",
        "misc_assets/food4.png",
        "misc_assets/meteorBrown_big3.png",
        "misc_assets/meteorBrown_big2.png",
        "misc_assets/ufoGreen.png",
        "misc_assets/food5.png",
        "misc_assets/spaceMeteors_002.png",
        "misc_assets/carrot.png",
        "misc_assets/enemyShipGreen4.png",
        "misc_assets/ship_6.png",
        "misc_assets/spaceEffect9.png",
        "misc_assets/fenceYellow.png",
        "misc_assets/character4.png",
        "misc_assets/character11.png",
        "misc_assets/frog4.png",
        "misc_assets/enemySpikey_2.png",
        "misc_assets/powerupRed_star.png",
        "misc_assets/car_red_4.png",
        "misc_assets/character13.png",
        "misc_assets/frog6.png",
        "misc_assets/ball_soccer1.png",
        "misc_assets/character6.png",
        "misc_assets/ship_4.png",
        "misc_assets/meteorBrown_big1.png",
        "misc_assets/food6.png",
        "misc_assets/spaceMeteors_001.png",
        "misc_assets/ship_5.png",
        "misc_assets/character7.png",
        "misc_assets/frog7.png",
        "misc_assets/fishTile_078.png",
        "misc_assets/character12.png",
        "misc_assets/enemySpikey_1.png",
        "misc_assets/car_red_5.png",
        "misc_assets/enemyWalking_2.png",
        "misc_assets/car_red_1.png",
        "misc_assets/character3.png",
        "misc_assets/frog3.png",
        "misc_assets/ship_1.png",
        "misc_assets/enemyShipGreen3.png",
        "misc_assets/zombie2_silencer.png",
        "misc_assets/food2.png",
        "misc_assets/meteorBrown_big4.png",
        "misc_assets/food3.png",
        "misc_assets/spaceMeteors_004.png",
        "misc_assets/present1.png",
        "misc_assets/enemyShipGreen2.png",
        "misc_assets/playerShip1_blue.png",
        "misc_assets/frog2.png",
        "misc_assets/character2.png",
        "misc_assets/enemyWalking_3.png",
        "misc_assets/enemySpikey_4.png",
        "misc_assets/fishTile_080.png",
        "misc_assets/robot_greenDrive1.png",
        "misc_assets/car_red_2.png",
        "misc_assets/enemyWalking_1.png",
        "misc_assets/tile_bricksRed.png",
        "misc_assets/ship_2.png",
        "misc_assets/present3.png",
        "misc_assets/food1.png",
        "misc_assets/spaceShips_009.png",
        "misc_assets/spaceShips_008.png",
        "misc_assets/shield2.png",
        "misc_assets/present2.png",
        "misc_assets/enemyShipGreen1.png",
        "misc_assets/ship_3.png",
        "misc_assets/frog1.png",
        "misc_assets/tank_darkLarge.png",
        "misc_assets/character1.png",
        "misc_assets/car_red_3.png",
        "misc_assets/enemySpikey_1b.png",
        "misc_assets/spaceEffect1.png",
        "misc_assets/genericItem_color_001.png",
        "misc_assets/playerShip2_red.png",
        "misc_assets/spaceShips_005.png",
        "misc_assets/spaceShips_004.png",
        "misc_assets/keyRed.png",
        "misc_assets/iconCircle_white.png",
        "misc_assets/tank_blue.png",
        "misc_assets/bunny2_stand.png",
        "misc_assets/panel_wood.png",
        "misc_assets/towerDefense_tile203.png",
        "misc_assets/enemyFloating_1.png",
        "misc_assets/fishTile_072.png",
        "misc_assets/enemyFloating_3.png",
        "misc_assets/spaceEffect2.png",
        "misc_assets/genericItem_color_002.png",
        "misc_assets/laserGreen14.png",
        "misc_assets/spaceShips_006.png",
        "misc_assets/enemyShipBlue4.png",
        "misc_assets/enemyShipBlue5.png",
        "misc_assets/spaceShips_007.png",
        "misc_assets/lock_blue.png",
        "misc_assets/genericItem_color_003.png",
        "misc_assets/cheese.png",
        "misc_assets/spaceEffect3.png",
        "misc_assets/window.png",
        "misc_assets/tileStone_slope2.png",
        "misc_assets/enemyFloating_2.png",
        "misc_assets/doorOpen_top.png",
        "misc_assets/elementWood044.png",
        "misc_assets/tank_red.png",
        "misc_assets/spaceEffect7.png",
        "misc_assets/spaceShips_003.png",
        "misc_assets/playerShip3_green.png",
        "misc_assets/enemyShipBlue1.png",
        "misc_assets/ball_tennis1.png",
        "misc_assets/spaceShips_002.png",
        "misc_assets/tank_huge.png",
        "misc_assets/genericItem_color_006.png",
        "misc_assets/spaceEffect6.png",
        "misc_assets/fishTile_074.png",
        "misc_assets/bunny2_jump.png",
        "misc_assets/fishTile_076.png",
        "misc_assets/character9.png",
        "misc_assets/spaceEffect4.png",
        "misc_assets/genericItem_color_004.png",
        "misc_assets/keyBlue.png",
        "misc_assets/roadTile6.png",
        "misc_assets/enemyShipBlue2.png",
        "misc_assets/playerShip3_red.png",
        "misc_assets/finish.png",
        "misc_assets/enemyShipBlue3.png",
        "misc_assets/spaceShips_001.png",
        "misc_assets/genericItem_color_005.png",
        "misc_assets/playerShip3_orange.png",
        "misc_assets/enemyFloating_4.png",
        "misc_assets/spaceEffect5.png",
        "misc_assets/character8.png",
        "misc_assets/car_yellow_1.png",
        "misc_assets/explosion1.png",
        "misc_assets/doorOpen_mid.png",
        "misc_assets/enemyFloating_1b.png",
        "misc_assets/finish2.png",
        "misc_assets/laserRed11.png",
        "misc_assets/meteorGrey_big2.png",
        "misc_assets/meteorGrey_big3.png",
        "misc_assets/ball_volley2.png",
        "misc_assets/tileStone_slope.png",
        "misc_assets/bunny2_walk1.png",
        "misc_assets/blockRed.png",
        "misc_assets/car_yellow_2.png",
        "misc_assets/explosion2.png",
        "misc_assets/terrainTile6.png",
        "misc_assets/fence_single.png",
        "misc_assets/playerShip1_red.png",
        "misc_assets/fireball.png",
        "misc_assets/bunny2_ready.png",
        "misc_assets/car_blue_5.png",
        "misc_assets/gemBlue.png",
        "misc_assets/ufoGreen2.png",
        "misc_assets/meteorGrey_big1.png",
        "misc_assets/tile_316.png",
        "misc_assets/car_blue_4.png",
        "misc_assets/bunny2_walk2.png",
        "misc_assets/ufoRed.png",
        "misc_assets/lock_red.png",
        "misc_assets/playerShip3_blue.png",
        "misc_assets/playerShip2_blue.png",
        "misc_assets/explosion3.png",
        "misc_assets/car_yellow_3.png",
        "misc_assets/keyRed2.png",
        "misc_assets/elementStone007.png",
        "misc_assets/towerDefense_tile298.png",
        "misc_assets/playerShip2_green.png",
        "misc_assets/lock_green.png",
        "misc_assets/meteorGrey_big4.png",
        "misc_assets/laserBlue09.png",
        "misc_assets/car_blue_1.png",
        "misc_assets/explosion4.png",
        "misc_assets/car_yellow_4.png",
        "misc_assets/target_red2.png",
        "misc_assets/towerDefense_tile270.png",
        "misc_assets/tile_bricksGrey.png",
        "misc_assets/car_blue_3.png",
        "misc_assets/playerShip1_orange.png",
        "misc_assets/roadTile6b.png",
        "misc_assets/manBlue_silencer.png",
        "misc_assets/tile_bricksGrown.png",
        "misc_assets/car_blue_2.png",
        "misc_assets/tank_dark.png",
        "misc_assets/lockRed2.png",
        "misc_assets/car_yellow_5.png",
        "misc_assets/explosion5.png",
        "platformer/playerBlue_dead.png",
        "platformer/playerBlue_roll.png",
        "platformer/playerRed_walk4.png",
        "platformer/playerRed_walk5.png",
        "platformer/tileYellow_06.png",
        "platformer/playerRed_duck.png",
        "platformer/tileGreen_08.png",
        "platformer/playerGreen_switch2.png",
        "platformer/playerGreen_up2.png",
        "platformer/playerRed_walk2.png",
        "platformer/blueCrystal.png",
        "platformer/playerRed_walk3.png",
        "platformer/playerGreen_up3.png",
        "platformer/playerGreen_up1.png",
        "platformer/playerGreen_switch1.png",
        "platformer/playerRed_walk1.png",
        "platformer/playerGreen_hit.png",
        "platformer/yellowCrystal.png",
        "platformer/tileBlue_05.png",
        "platformer/shroom1.png",
        "platformer/playerGreen_roll.png",
        "platformer/playerGreen_dead.png",
        "platformer/playerRed_hit.png",
        "platformer/tileBrown_06.png",
        "platformer/playerRed_up1.png",
        "platformer/shroom2.png",
        "platformer/playerRed_up3.png",
        "platformer/playerRed_fall.png",
        "platformer/playerGrey_roll.png",
        "platformer/playerGrey_dead.png",
        "platformer/shroom3.png",
        "platformer/playerRed_up2.png",
        "platformer/playerBlue_swim2.png",
        "platformer/playerGrey_up3.png",
        "platformer/playerGrey_swim1.png",
        "platformer/playerGreen_swim2.png",
        "platformer/playerGrey_up2.png",
        "platformer/shroom6.png",
        "platformer/playerBlue_swim1.png",
        "platformer/shroom4.png",
        "platformer/playerRed_stand.png",
        "platformer/playerGrey_swim2.png",
        "platformer/playerGrey_hit.png",
        "platformer/playerGreen_swim1.png",
        "platformer/playerGrey_up1.png",
        "platformer/shroom5.png",
        "platformer/enemySwimming_4.png",
        "platformer/zombie_jump.png",
        "platformer/playerBlue_walk5.png",
        "platformer/playerBlue_up2.png",
        "platformer/playerGreen_walk4.png",
        "platformer/playerGreen_walk5.png",
        "platformer/playerBlue_up3.png",
        "platformer/playerBlue_walk4.png",
        "platformer/playerGrey_walk4.png",
        "platformer/playerBlue_hit.png",
        "platformer/playerBlue_up1.png",
        "platformer/playerGrey_walk5.png",
        "platformer/playerBlue_duck.png",
        "platformer/enemySwimming_2.png",
        "platformer/playerGrey_walk1.png",
        "platformer/playerBlue_walk3.png",
        "platformer/playerGreen_walk2.png",
        "platformer/playerGreen_walk3.png",
        "platformer/playerGreen_fall.png",
        "platformer/tileBrown_09.png",
        "platformer/playerBlue_walk2.png",
        "platformer/enemySwimming_3.png",
        "platformer/playerGrey_walk2.png",
        "platformer/enemySwimming_1.png",
        "platformer/playerGrey_fall.png",
        "platformer/greenCrystal.png",
        "platformer/redCrystal.png",
        "platformer/playerGreen_walk1.png",
        "platformer/playerRed_dead.png",
        "platformer/playerBlue_walk1.png",
        "platformer/playerRed_roll.png",
        "platformer/playerGrey_walk3.png",
        "platformer/tileBlue_08.png",
        "platformer/zombie_walk1.png",
        "platformer/fireball.png",
        "platformer/zombie_walk2.png",
        "platformer/zombie_idle.png",
        "platformer/playerGrey_switch2.png",
        "platformer/tileGreen_05.png",
        "platformer/playerGrey_stand.png",
        "platformer/playerBlue_switch1.png",
        "platformer/playerGreen_duck.png",
        "platformer/playerBlue_fall.png",
        "platformer/playerRed_switch1.png",
        "platformer/playerRed_swim2.png",
        "platformer/playerGrey_switch1.png",
        "platformer/playerBlue_switch2.png",
        "platformer/tileYellow_09.png",
        "platformer/playerGreen_stand.png",
        "platformer/playerBlue_stand.png",
        "platformer/playerRed_switch2.png",
        "platformer/playerRed_swim1.png",
        "platformer/playerGrey_duck.png",
    };

    for (const auto& sprite_path : sprite_paths) {
        sprites[sprite_path] = load_resource_ptr(sprite_path, QImage::Format_ARGB32_Premultiplied);
    }

    auto group_to_vector = std::map<std::string, std::vector<std::shared_ptr<QImage>> *>{
        {"space_backgrounds", &space_backgrounds},
        {"platform_backgrounds", &platform_backgrounds},
        {"topdown_backgrounds", &topdown_backgrounds},
        {"topdown_simple_backgrounds", &topdown_simple_backgrounds},
        {"water_backgrounds", &water_backgrounds},
        {"water_surface_backgrounds", &water_surface_backgrounds},
    };

    auto group_to_paths = std::map<std::string, std::vector<std::string>>{
        {
            "space_backgrounds",
            {
                "space_backgrounds/deep_space_01.png",
                "space_backgrounds/spacegen_01.png",
                "space_backgrounds/milky_way_01.png",
                "space_backgrounds/ez_space_lite_01.png",
                "space_backgrounds/meyespace_v1_01.png",
                "space_backgrounds/eye_nebula_01.png",
                "space_backgrounds/deep_sky_01.png",
                "space_backgrounds/space_nebula_01.png",
                "space_backgrounds/Background-1.png",
                "space_backgrounds/Background-2.png",
                "space_backgrounds/Background-3.png",
                "space_backgrounds/Background-4.png",
                "space_backgrounds/parallax-space-backgound.png",
            },
        },
        {
            "platform_backgrounds",
            {
                "platform_backgrounds/alien_bg.png",
                "platform_backgrounds/another_world_bg.png",
                "platform_backgrounds/back_cave.png",
                "platform_backgrounds/caverns.png",
                "platform_backgrounds/cyberpunk_bg.png",
                "platform_backgrounds/parallax_forest.png",
                "platform_backgrounds/scifi_bg.png",
                "platform_backgrounds/scifi2_bg.png",
                "platform_backgrounds/living_tissue_bg.png",
                "platform_backgrounds/airadventurelevel1.png",
                "platform_backgrounds/airadventurelevel2.png",
                "platform_backgrounds/airadventurelevel3.png",
                "platform_backgrounds/airadventurelevel4.png",
                "platform_backgrounds/cave_background.png",
                "platform_backgrounds/blue_desert.png",
                "platform_backgrounds/blue_grass.png",
                "platform_backgrounds/blue_land.png",
                "platform_backgrounds/blue_shroom.png",
                "platform_backgrounds/colored_desert.png",
                "platform_backgrounds/colored_grass.png",
                "platform_backgrounds/colored_land.png",
                "platform_backgrounds/colored_shroom.png",
                "platform_backgrounds/landscape1.png",
                "platform_backgrounds/landscape2.png",
                "platform_backgrounds/landscape3.png",
                "platform_backgrounds/landscape4.png",
                "platform_backgrounds/battleback1.png",
                "platform_backgrounds/battleback2.png",
                "platform_backgrounds/battleback3.png",
                "platform_backgrounds/battleback4.png",
                "platform_backgrounds/battleback5.png",
                "platform_backgrounds/battleback6.png",
                "platform_backgrounds/battleback7.png",
                "platform_backgrounds/battleback8.png",
                "platform_backgrounds/battleback9.png",
                "platform_backgrounds/battleback10.png",
                "platform_backgrounds/sunrise.png",
                "platform_backgrounds_2/beach1.png",
                "platform_backgrounds_2/beach2.png",
                "platform_backgrounds_2/beach3.png",
                "platform_backgrounds_2/beach4.png",
                "platform_backgrounds_2/fantasy1.png",
                "platform_backgrounds_2/fantasy2.png",
                "platform_backgrounds_2/fantasy3.png",
                "platform_backgrounds_2/fantasy4.png",
                "platform_backgrounds_2/candy1.png",
                "platform_backgrounds_2/candy2.png",
                "platform_backgrounds_2/candy3.png",
                "platform_backgrounds_2/candy4.png",
            },
        },
        {
            "topdown_backgrounds",
            {
                "topdown_backgrounds/floortiles.png",
                "topdown_backgrounds/backgrounddetailed1.png",
                "topdown_backgrounds/backgrounddetailed2.png",
                "topdown_backgrounds/backgrounddetailed3.png",
                "topdown_backgrounds/backgrounddetailed4.png",
                "topdown_backgrounds/backgrounddetailed5.png",
                "topdown_backgrounds/backgrounddetailed6.png",
                "topdown_backgrounds/backgrounddetailed7.png",
                "topdown_backgrounds/backgrounddetailed8.png",
            },
        },
        {
            "topdown_simple_backgrounds",
            {
                "topdown_backgrounds/floortiles.png",
            },
        },
        {
            "water_backgrounds",
            {
                "water_backgrounds/water1.png",
                "water_backgrounds/water2.png",
                "water_backgrounds/water3.png",
                "water_backgrounds/water4.png",
                "water_backgrounds/underwater1.png",
                "water_backgrounds/underwater2.png",
                "water_backgrounds/underwater3.png",
            },
        },
        {
            "water_surface_backgrounds",
            {

                "water_backgrounds/water1.png",
                "water_backgrounds/water2.png",
                "water_backgrounds/water3.png",
                "water_backgrounds/water4.png",
            },
        },
    };

    for (auto const &pair : group_to_paths) {
        auto vec = group_to_vector.at(pair.first);
        for (const auto &path : pair.second) {
            vec->push_back(load_resource_ptr(path, QImage::Format_RGB32));
        }
    }

    // also add all space backgrounds as platform backgrounds
    for (auto bg : space_backgrounds) {
        platform_backgrounds.push_back(bg);
    }
}
